/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

define(['backbone', 'parser'],
    function (Backbone, parser) {
        'use strict';

        var Patient,
            singleInstance;

        Patient = Backbone.Model.extend({
            initialize: function () {
                _.bindAll(this);
            },
            isEmpty: function () {
                return _.size(this.attributes) === 0;
            },
            parse: function (response) {
                if (typeof response === "undefined") {
                    // no patient in context
                    return {};
                } else {
                    parser.preFlattenLinks(response);

                    if ( typeof response.patientId !== "undefined" || typeof response.assigningAuthority !== "undefined" ) {
                        response.patientId = response.patientIdentifier.uniqueId;
                        response.assigningAuthority = response.patientIdentifier.assigningAuthority;
                    }

                    return response;
                }
            },
            flattenLinks: function() {
                parser.flattenLinks(this);
            }
        });

        Patient.instance = function () {
            if (singleInstance === undefined) {
                singleInstance = new Patient();
            }
            return singleInstance;
        };

        return Patient;
    });